<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\DI;

use Core\DI\CompilerExtension;
use EshopProductsComparison\FrontModule\Model\Provider\IXmlExportService;
use Nette;

class EshopProductionWarehouseExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopProductionWarehouse' => 'EshopProductionWarehouse\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$ref = new \ReflectionClass(static::class);
		$componentsDir = dirname($ref->getFileName()) . '/../AdminModule/Components/UI';

		$init->addBody('EshopProductionWarehouse\Model\EshopProductionWarehouseConfig::setParams($this->parameters[\'eshopProductionWarehouse\']);');
		$init->addBody(sprintf('define("EPW_COMPONENTS_DIR", \'%s\');', $componentsDir));
		$init->addBody('if (!$this->parameters[\'eshopCatalog\'][\'config\'][\'pseudoWarehouse\']) { throw new \Nette\InvalidStateException(\'You must enable pseudoWarehouse\'); }');
	}
}
