<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Console;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Doctrine\ORM\Tools\SchemaTool;
use EshopCatalog\Model\Entities\Product;
use EshopProductionWarehouse\AdminModule\Model\Facade\WarehouseFacade;
use Exception;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

/**
 * Nastaví pole quantity u vsech produktů dle příjemek a výdejek
 */
class RepairProductQuantityByWarehouse extends AbstractCommand
{
	/** @var EntityManagerDecorator @inject */
	public $em;

	/** @var WarehouseFacade @inject */
	public $wf;

	protected function configure(): void
	{
		$this->setName('eshopproductionwarehouse:warehouse:repairProductQuantityByWarehouse');
	}

	/**
	 * @inheritDoc
	 */
	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): ?int
	{
		$output->writeln('EshopProductionWarehouse - repairProductQuantityByWarehouse');

		try {
			ini_set('memory_limit', '5G');
			Debugger::dispatch();

			$connection = $this->em->getConnection();
			$connection->transactional(function() {
				$qb = $this->em->getRepository(Product::class)->createQueryBuilder('p', 'p.id');

				/** @var Product[] $products */
				$products = $qb->getQuery()->getResult();

				$state = $this->wf->getState();
				foreach ($products as $product) {
					if (isset($state[$product->getId()])) {
						$product->quantity = (int) $state[$product->getId()]['quantity'];
						$this->em->persist($product);
					}
				}

				$this->em->flush();

			});

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}