<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use Core\Model\Helpers\Strings;
use EshopCatalog\Model\Entities\Product;
use EshopProductionWarehouse\AdminModule\Model\Common\IOperation;
use Doctrine\ORM\Mapping as ORM;

abstract class WarehouseMovementOperation implements IOperation
{
	protected array $extras = [];

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="cascade", nullable=false)
	 */
	protected Product $product;

	/**
	 * @ORM\ManyToOne(targetEntity="WarehouseMovement")
	 * @ORM\JoinColumn(name="id_warehouse_movement", referencedColumnName="id", onDelete="cascade", nullable=false)
	 */
	public WarehouseMovement $warehouseMovement;

	/**
	 * @var double|string
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=false)
	 */
	protected $quantity;

	public function __construct(Product $product, WarehouseMovement $warehouseMovement, float $quantity)
	{
		$this->product = $product;
		$this->warehouseMovement = $warehouseMovement;
		$this->setQuantity($quantity);
	}

	public function getQuantity(): float
	{
		return (float) $this->quantity;
	}

	public function setQuantity($quantity): self
	{
		$this->quantity = (string) Strings::formatEntityDecimal($quantity);
		return $this;
	}

	public function getProduct(): Product
	{
		return $this->product;
	}

	public function setProduct(Product $product): self
	{
		return $this;
	}

	public function getExtras(): array
	{
		return $this->extras;
	}

	public function setExtras(array $extras): self
	{
		$this->extras = $extras;
		return $this;
	}

	public function setExtra($key, $val): self
	{
		$this->extras[$key] = $val;
		return $this;
	}

}