<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use EshopOrders\Model\Entities\Order;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_production_warehouse__warehouse_order")
 */
class WarehouseOrder
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Warehouse")
	 * @ORM\JoinColumn(name="warehouse_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
	 */
	public Warehouse $warehouse;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
	 */
	public Order $order;

	/**
	 * @ORM\Column(type="smallint", options={"default": 1})
	 */
	public int $countInStatistics = 1;

	/**
	 * @ORM\Column(type="smallint", options={"default": 0})
	 */
	public int $transferredToEshopCheckoutWarehouse = 0;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $lastAction = null;

	public function __construct(Warehouse $warehouse, Order $order)
	{
		$this->warehouse = $warehouse;
		$this->order = $order;
	}

}