<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Listeners;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopProductionWarehouse\AdminModule\Model\Facade\NumericalSeriesFacade;
use EshopProductionWarehouse\Model\Entities\NumericalSeries;
use EshopProductionWarehouse\Model\Entities\WarehouseMovement;

class WarehouseMovementListener
{
	protected NumericalSeriesFacade $numericalSeriesFacade;

	public function __construct(NumericalSeriesFacade $numericalSeriesFacade)
	{
		$this->numericalSeriesFacade = $numericalSeriesFacade;
	}

	/**
	 * @ORM\PrePersist
	 */
	public function prePersist(WarehouseMovement $warehouseMovement, LifecycleEventArgs $event): void
	{
		$entityManager = $event->getEntityManager();

		$flush = [];
		if ($warehouseMovement->inputNumber === null && $warehouseMovement->getInputs()) {
			/** @var NumericalSeries $numSeries */
			$numSeries = $entityManager->getRepository(NumericalSeries::class)->find(NumericalSeries::INPUT_NUM_SERIES_IDENT);
			$warehouseMovement->inputNumber = $this->numericalSeriesFacade->getInputNumber();

			$numSeries->increase();

			$entityManager->persist($numSeries);
			$flush[] = $numSeries;
		}

		if ($warehouseMovement->outputNumber === null && $warehouseMovement->getOutputs()) {
			/** @var NumericalSeries $numSeries */
			$numSeries = $entityManager->getRepository(NumericalSeries::class)->find(NumericalSeries::OUTPUT_NUM_SERIES_IDENT);
			$warehouseMovement->outputNumber = $this->numericalSeriesFacade->getOutputNumber();

			$numSeries->increase();

			$entityManager->persist($numSeries);
			$flush[] = $numSeries;
		}

		foreach ($flush as $e) {
			$entityManager->flush($e);
		}
	}
}