<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Utils;

use EshopCatalog\Model\Entities\Product;
use Nette\InvalidArgumentException;
use Olifolkerd\Convertor\Convertor;

class UnitsHelper
{
	public static function findRelatedUnits(string $unit): array
	{
		if (!in_array($unit, Product::UNITS, true)) {
			throw new InvalidArgumentException("Unknown unit '${$unit}'");
		}

		/** V $map musi byt vsechny jednotky z Product::UNITS  */
		$map = [
			['pieces' => 'pieces'], // kusove jednotky
			['kg' => 'kg', 'g' => 'g'], // vahove jednotky
			['l' => 'l', 'dl' => 'dl', 'ml' => 'ml'] // objemove jednotky
		];

		foreach ($map as $units) {
			if (in_array($unit, $units, true)) {
				return $units;
			}
		}

		throw new InvalidArgumentException("Unknown unit '${$unit}'");
	}

	/**
	 * @return float|array
	 */
	public static function convert(string $from, string $to, float $value)
	{
		if ($from === 'pieces' || $to === 'pieces' || $from === $to) {
			return $value;
		}

		$convertor = new Convertor($value, $from);
		return $convertor->to($to);
	}
}