<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Utils;

use EshopProductionWarehouse\Model\EshopProductionWarehouseConfig;
use Nette\Schema\Expect;
use Nette\Schema\Processor;
use Nette\Utils\Floats;

class Validators
{
	/**
	 * @param array{id: int, quantity: float, unlimitedQuantity: bool, enabledNegativeQuantity: bool} $productArr
	 */
	public static function isDisallowedProductQuantity(array $productArr, float $quantityDiff): bool
	{
		$schema = Expect::structure([
			'id'                      => Expect::int(),
			'quantity'                => Expect::float(),
			'unlimitedQuantity'       => Expect::bool(),
			'enabledNegativeQuantity' => Expect::bool()
		])->otherItems();
		(new Processor)->process($schema, $productArr);

		$enabledNegativeQuantity = $productArr['enabledNegativeQuantity'];
		if (!EshopProductionWarehouseConfig::load('enableNegativeQuantity')) {
			$enabledNegativeQuantity = false;
		}

		if ($productArr['unlimitedQuantity']) {
			return false;
		}

		return !$enabledNegativeQuantity && Floats::isLessThan($productArr['quantity'] + $quantityDiff, 0.0);
	}
}