<?php

declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Utils\DateTime;
use Nette\Utils\Floats;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20220608104723 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()
										->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE eshop_production_warehouse__batch (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_production_warehouse__batch_input (id INT AUTO_INCREMENT NOT NULL, id_product INT NOT NULL, id_batch INT NOT NULL, quantity NUMERIC(10, 2) NOT NULL, INDEX IDX_7B2D3367DD7ADDD (id_product), INDEX IDX_7B2D3367168E13E4 (id_batch), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_production_warehouse__batch_output (id INT AUTO_INCREMENT NOT NULL, id_product INT NOT NULL, id_batch INT NOT NULL, quantity NUMERIC(10, 2) NOT NULL, INDEX IDX_71CA213DD7ADDD (id_product), INDEX IDX_71CA213168E13E4 (id_batch), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_production_warehouse__warehouse_movement (id INT AUTO_INCREMENT NOT NULL, date DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_production_warehouse__warehouse_movement_input (id INT AUTO_INCREMENT NOT NULL, id_product INT NOT NULL, id_warehouse_movement INT NOT NULL, quantity NUMERIC(10, 2) NOT NULL, INDEX IDX_394B4BF4DD7ADDD (id_product), INDEX IDX_394B4BF457B745FE (id_warehouse_movement), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_production_warehouse__warehouse_movement_output (id INT AUTO_INCREMENT NOT NULL, id_product INT NOT NULL, id_warehouse_movement INT NOT NULL, quantity NUMERIC(10, 2) NOT NULL, INDEX IDX_6E580695DD7ADDD (id_product), INDEX IDX_6E58069557B745FE (id_warehouse_movement), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_production_warehouse__batch_input ADD CONSTRAINT FK_7B2D3367DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__batch_input ADD CONSTRAINT FK_7B2D3367168E13E4 FOREIGN KEY (id_batch) REFERENCES eshop_production_warehouse__batch (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__batch_output ADD CONSTRAINT FK_71CA213DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__batch_output ADD CONSTRAINT FK_71CA213168E13E4 FOREIGN KEY (id_batch) REFERENCES eshop_production_warehouse__batch (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_input ADD CONSTRAINT FK_394B4BF4DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_input ADD CONSTRAINT FK_394B4BF457B745FE FOREIGN KEY (id_warehouse_movement) REFERENCES eshop_production_warehouse__warehouse_movement (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_output ADD CONSTRAINT FK_6E580695DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_output ADD CONSTRAINT FK_6E58069557B745FE FOREIGN KEY (id_warehouse_movement) REFERENCES eshop_production_warehouse__warehouse_movement (id) ON DELETE CASCADE');
	}

	public function postUp(Schema $schema): void
	{
		$this->connection->transactional(function() {
			$products = $this->connection->fetchAll("SELECT id, quantity FROM eshop_catalog__product");

			$this->connection->prepare("INSERT INTO eshop_production_warehouse__warehouse_movement(date) VALUES(?)")
							 ->execute(['date' => new DateTime]);

			$movementId = $this->connection->lastInsertId();

			foreach ($products as $product) {
				$id = $product['id'];
				$quantity = $product['quantity'];

				if (Floats::isLessThan($quantity, 0.0)) {
					$this->connection->prepare("INSERT INTO eshop_production_warehouse__warehouse_movement_output (id_product, id_warehouse_movement, quantity) VALUES (?, ?, ?)")
									 ->execute([
										 'id_product'            => $id,
										 'id_warehouse_movement' => $movementId,
										 'quantity'              => abs($quantity)
									 ]);
				} else if (Floats::isGreaterThan($quantity, 0.0)) {
					$this->connection->prepare("INSERT INTO eshop_production_warehouse__warehouse_movement_input (id_product, id_warehouse_movement, quantity) VALUES (?, ?, ?)")
									 ->execute([
										 'id_product'            => $id,
										 'id_warehouse_movement' => $movementId,
										 'quantity'              => abs($quantity)
									 ]);
				}
			}
		});
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()
										->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_production_warehouse__batch_input DROP FOREIGN KEY FK_7B2D3367168E13E4');
		$this->addSql('ALTER TABLE eshop_production_warehouse__batch_output DROP FOREIGN KEY FK_71CA213168E13E4');
		$this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_input DROP FOREIGN KEY FK_394B4BF457B745FE');
		$this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_output DROP FOREIGN KEY FK_6E58069557B745FE');
		$this->addSql('DROP TABLE eshop_production_warehouse__batch');
		$this->addSql('DROP TABLE eshop_production_warehouse__batch_input');
		$this->addSql('DROP TABLE eshop_production_warehouse__batch_output');
		$this->addSql('DROP TABLE eshop_production_warehouse__warehouse_movement');
		$this->addSql('DROP TABLE eshop_production_warehouse__warehouse_movement_input');
		$this->addSql('DROP TABLE eshop_production_warehouse__warehouse_movement_output');
	}
}
