<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Facade;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Product;
use EshopProductionWarehouse\AdminModule\Model\ProductExtraFields;
use Nette\Localization\Translator;

class ProductsFacade extends BaseEntityService
{
	protected $entityClass = Product::class;
	protected Translator $translator;
	protected ProductExtraFields $productExtraFields;

	public function __construct(Translator $translator, ProductExtraFields $productExtraFields)
	{
		$this->translator = $translator;
		$this->productExtraFields = $productExtraFields;
	}

	/**
	 * @return array<int, array{id: int, name: string, units: string}>
	 */
	public function getFinalProducts(): array
	{
		$qb = $this->getEr()->createQueryBuilder('p', 'p.id');
		$qb->select('p.id, pt.name, p.units')
		   ->addSelect(sprintf('(%s) as HIDDEN isProductionRawMaterial', $this->productExtraFields->getIsProductionRawMaterialQb()->getDQL()))
		   ->join('p.productTexts', 'pt', 'WITH', 'pt.lang = :lang')
		   ->orderBy('pt.name')
		   ->andHaving('(isProductionRawMaterial = 0 OR isProductionRawMaterial IS NULL)')
		   ->setParameters([
			   'key'   => 'isProductionRawMaterial',
			   'value' => '1',
			   'sn'    => Product::EXTRA_FIELD_SECTION,
			   'lang'  => $this->translator->getLocale()
		   ]);

		return $qb->getQuery()->getArrayResult();
	}

	/**
	 * @return array<int, array{id: int, name: string, units: string}>
	 */
	public function getAll(): array
	{
		$qb = $this->getEr()->createQueryBuilder('p', 'p.id');
		$qb->select('p.id, pt.name, p.units')
		   ->join('p.productTexts', 'pt', 'WITH', 'pt.lang = :lang')
		   ->orderBy('pt.name')
		   ->setParameters([
			   'lang'  => $this->translator->getLocale()
		   ]);

		return $qb->getQuery()->getArrayResult();
	}

}