<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Subscribers;

use Core\Model\Event\FormValidateEvent;
use EshopOrders\AdminModule\Components\Order\OrderItemAddForm;
use EshopOrders\AdminModule\Components\Order\OrderItemForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;
use EshopProductionWarehouse\AdminModule\Model\Facade\WarehouseFacade;
use EshopProductionWarehouse\Model\Utils\Validators;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Core\Model\Entities\EntityManagerDecorator;

class OrderItemChangedSubscriber implements EventSubscriberInterface
{
	protected WarehouseFacade $warehouseFacade;
	protected EntityManagerDecorator $em;

	public function __construct(WarehouseFacade $warehouseFacade, EntityManagerDecorator $em)
	{
		$this->warehouseFacade = $warehouseFacade;
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			OrderItemAddForm::class . '::formValidate' => 'orderItemFormValidate',
			OrderItemForm::class . '::formValidate'    => 'orderItemFormValidate',
		];
	}

	public function orderItemFormValidate(FormValidateEvent $event): void
	{
		/** @var Order $order */
		$order = $event->custom['order'];
		$productId = null;
		$quantityDiff = 0; // zaporne cislo

		/** @var OrderItem|null $orderItem */
		if ($orderItem = $event->custom['orderItem']) {
			$productId = $orderItem->getProduct()->getId();
			$conn = $this->em->getConnection();
			$result = $conn->fetchAssociative('SELECT quantity FROM eshop_orders__order_item WHERE id = ' . $orderItem->getId());

			if (!$result) {
				return;
			}

			$oldOrderItemQuantity = $result['quantity'];
			$quantityDiff = $oldOrderItemQuantity - $event->values->quantity;

			if ($quantityDiff >= 0) {
				return;
			}

		} else {
			if ($event->values->productId) {
				$productId = (int) $event->values->productId;
				$quantityDiff = -((int) $event->values->quantity);
			} else {
				return;
			}
		}

		$quantityDiff = (float) $quantityDiff;
		$warehouse = $this->warehouseFacade->getWarehouseByOrder($order->getId());
		$warehouseState = $this->warehouseFacade->getState(null, [$productId], $warehouse ? $warehouse->getId() : null);
		$warehouseProductState = $warehouseState[$productId] ?? null;

		if (!$warehouseProductState) {
			return;
		}

		if (Validators::isDisallowedProductQuantity($warehouseProductState, $quantityDiff)) {
			$event->form->addError('eshopProductionWarehouse.orderItemForm.errors.productQuantityNotEnough');
		}
	}

}