<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Subscribers;

use Core\Model\Event\Event;
use EshopCatalog\AdminModule\Components\Products\ProductsGrid;
use EshopCatalog\Model\Entities\Product;
use EshopProductionWarehouse\AdminModule\Model\Facade\WarehouseFacade;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductsGridSubscriber implements EventSubscriberInterface
{
	protected WarehouseFacade $warehouseFacade;
	protected array $products = [];

	public function __construct(WarehouseFacade $warehouseFacade)
	{
		$this->warehouseFacade = $warehouseFacade;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ProductsGrid::class . '::beforeColumnQuantityRender' => 'beforeColumnQuantityRender',
			ProductsGrid::class . '::onDataLoaded'               => 'onDataLoaded'
		];
	}

	public function onDataLoaded(Event $event): void
	{
		$productIds = $event->data['ids'];
		$this->products = $this->warehouseFacade->getState(null, $productIds);
	}

	public function beforeColumnQuantityRender(Event $event): void
	{
		/** @var Product $product */
		$product = $event->data['product'];
		if (isset($this->products[$product->getId()])) {
			$event->data['renderedQuantity'] = $this->products[$product->getId()]['quantity'];
		}
	}

}