<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_production_warehouse__batch")
 */
class Batch
{
	use TId;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $name;

	/**
	 * @var Collection<int, BatchInput>
	 * @ORM\OneToMany(targetEntity="BatchInput", mappedBy="batch", cascade={"all"}, orphanRemoval=true)
	 */
	public Collection $inputs;

	/**
	 * @var Collection<int, BatchOutput>
	 * @ORM\OneToMany(targetEntity="BatchOutput", mappedBy="batch", cascade={"all"}, orphanRemoval=true)
	 */
	public Collection $outputs;

	public function __construct(string $name)
	{
		$this->name = $name;
		$this->inputs = new ArrayCollection;
		$this->outputs = new ArrayCollection;
	}

	public function addInput(BatchInput $input): void
	{
		$this->inputs->add($input);
	}

	public function removeInput(BatchInput $input): void
	{
		if ($this->inputs->contains($input)) {
			$this->inputs->removeElement($input);
		}
	}

	public function addOutput(BatchOutput $output): void
	{
		$this->outputs->add($output);
	}

	public function removeOutput(BatchOutput $output): void
	{
		if ($this->outputs->contains($output)) {
			$this->outputs->removeElement($output);
		}
	}

	/**
	 * @return BatchInput[]
	 */
	public function getInputs(): array
	{
		return $this->inputs->toArray();
	}

	/**
	 * @return BatchOutput[]
	 */
	public function getOutputs(): array
	{
		return $this->outputs->toArray();
	}

	/** @return int[] */
	public function getInputIds(): array
	{
		return array_map(fn(BatchInput $input) => $input->getId(), $this->inputs->toArray());
	}

	/** @return int[] */
	public function getOutputIds(): array
	{
		return array_map(fn(BatchOutput $output) => $output->getId(), $this->outputs->toArray());
	}

}