<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_production_warehouse__numerical_series")
 */
class NumericalSeries
{
	public const INPUT_NUM_SERIES_IDENT = 'inputNumSeries', OUTPUT_NUM_SERIES_IDENT = 'outputNumSeries';

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $ident;

	/**
	 * @ORM\Column(type="integer", options={"default":"1"})
	 */
	protected int $counter = 1;

	public function __construct(string $ident, int $counter)
	{
		$this->ident = $ident;
		$this->counter = $counter;
	}

	public function increase(): void
	{
		++$this->counter;
	}

	public function getCounter(): int
	{
		return $this->counter;
	}

}