<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_production_warehouse__warehouse", uniqueConstraints={@ORM\UniqueConstraint(name="eshop_production_ident__idx", columns={"ident"})})
 */
class Warehouse
{
	public const IDENT_ESHOP_WAREHOUSE = 'eshopWarehouse',
				IDENT_ESCHOPCHECKOUT_WAREHOUSE = 'eshopCheckoutWarehouse';

	use TId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $ident;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $name;

	/**
	 * @var Collection<int, WarehouseMovement>
	 * @ORM\OneToMany(targetEntity="WarehouseMovement", mappedBy="warehouse", cascade={"all"}, orphanRemoval=true)
	 */
	public Collection $movements;

	/**
	 * @var Collection<int, WarehouseOrder>
	 * @ORM\OneToMany(targetEntity="WarehouseOrder", mappedBy="warehouse", cascade={"all"}, orphanRemoval=true)
	 */
	public Collection $orders;

	public function __construct(string $ident, string $name)
	{
		$this->ident = $ident;
		$this->name = $name;
		$this->movements = new ArrayCollection;
		$this->orders = new ArrayCollection;
	}

}