<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopProductionWarehouse\AdminModule\Model\Repository\WarehouseRepository;
use EshopProductionWarehouse\Model\Entities\Warehouse;
use EshopProductionWarehouse\Model\Entities\WarehouseOrder;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected WarehouseRepository $warehouseRepository;

	public function __construct(EntityManagerDecorator $em, WarehouseRepository $warehouseRepository)
	{
		$this->em = $em;
		$this->warehouseRepository = $warehouseRepository;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['eshopOrder', 105],
			'eshopOrders.admin.orderOnSuccess' => ['eshopCheckoutOrder', 105],
		];
	}

	public function eshopCheckoutOrder(OrderEvent $event): void
	{
		$this->orderOnSuccess($event, Warehouse::IDENT_ESCHOPCHECKOUT_WAREHOUSE);
	}

	public function eshopOrder(OrderEvent $event): void
	{
		$this->orderOnSuccess($event, Warehouse::IDENT_ESHOP_WAREHOUSE);
	}

	protected function orderOnSuccess(OrderEvent $event, string $warehouseIdent): void
	{
		$order = $event->order;

		$warehouse = $this->warehouseRepository->findByIdent($warehouseIdent);

		if (!$warehouse) {
			return;
		}

		$warehouseOrder = new WarehouseOrder($warehouse, $order);

		$this->em->persist($warehouseOrder)->flush($warehouseOrder);
	}

}