<?php declare(strict_types = 1);

namespace EshopProductsComparison\AdminModule\Components\DashboardWidgets;

use Core\Model\Sites;
use Dashboard\AdminModule\Components\Widget;
use EshopProductsComparison\FrontModule\Model\Export\XmlService;

class Links extends Widget
{
	protected string $gridSize = 'col-md-9';
	protected string $key      = 'eshopProductsComparisonLink';

	public function __construct(
		public Sites $sites,
	)
	{
	}

	public function render(): void
	{
		if (!$this->loggedUser->isAllowed('EshopProductsComparison:Admin', 'access')) {
			return;
		}

		$this->template->key   = $this->key;
		$this->template->files = $this->parseFiles();
		$this->template->render($this->getTemplateFile());
	}

	protected function parseFiles(): array
	{
		$data  = [];
		$sites = $this->sites->getSites(false);

		foreach (glob(WWW_DIR . DS . XmlService::EXPORT_DIR_NAME . DS . '*.xml') ?: [] as $file) {
			$name = pathinfo($file, PATHINFO_FILENAME);
			$tmp  = explode('-', $name, 4);
			$site = $sites[$tmp[1]] ?? null;

			if (!$site) {
				continue;
			}

			$domain = $site->getDomains()[$tmp[2]] ?? null;
			if (!$domain) {
				continue;
			}

			$data[$tmp[1]][$tmp[0]][$tmp[2]][] = [
				'link' => '//' . $domain->getDomain() . '/' . XmlService::EXPORT_DIR_NAME . '/' . $name . '.xml',
				'name' => $name,
			];
		}

		return $data;
	}
}
