<?php declare(strict_types = 1);

namespace EshopProductsComparison\AdminModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\ControlEvent;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use EshopCatalog\AdminModule\Components\Products\ProductsGrid;
use EshopCatalog\Model\Entities\Product;
use EshopProductsComparison\Model\Entities\ProductExport;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductsGridSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			ProductsGrid::class . '::onAttach' => 'onAttach',
		];
	}

	public function onAttach(ControlEvent $event): void
	{
		/** @var ProductsGrid $control */
		$control = &$event->control;

		$control['grid']->addGroupTextAction('eshopProductsComparison.productsGrid.editZboziCustomlabel1')
			->onSelect[] = function(array $ids, $val) use ($control): void {

			$exports = [];
			foreach ((array) $this->em->getRepository(ProductExport::class)->createQueryBuilder('ppe')
				->where('ppe.id IN (' . implode(',', $ids) . ')')
				->andWhere('ppe.service = :service')
				->andWhere('ppe.lang = :lang')
				->setParameters(new ArrayCollection([new Parameter('service', 'zbozi'), new Parameter('lang', 'cs')]))->getQuery()->getResult() as $row) {
				/** @var ProductExport $row */
				$exports[$row->id->getId()] = $row;
			}

			foreach ($ids as $id) {
				/** @var Product $product */
				$product = $this->em->getReference(Product::class, $id);

				$export               = $exports[$id] ?? new ProductExport($product, 'cs', 'zbozi');
				$export->customLabel1 = $val;

				$this->em->persist($export);
			}

			$this->em->flush();

			$presenter = $control->presenter;
			$presenter->flashMessageSuccess('default.saved');
			$presenter->redrawControl('flashes');
		};
	}
}
