<?php declare(strict_types = 1);

namespace EshopProductsComparison\DI;

use Core\DI\CompilerExtension;
use EshopProductsComparison\FrontModule\Model\Provider\IXmlExportService;
use Nette\DI\Definitions\ServiceDefinition;
use Nette\DI\Definitions\Statement;
use Nette\PhpGenerator\ClassType;
use Override;

class EshopProductsComparisonExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopProductsComparison' => 'EshopProductsComparison\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var ServiceDefinition $def */
		$def = $builder->getDefinition('eshopProductsComparison.front.xmlExportCollection');
		$def->addSetup(new Statement('$service->setServices(?)', [$builder->findByType(IXmlExportService::class)]));
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopProductsComparison\Model\EshopProductsComparisonConfig::setParams(?);', [$builder->parameters['eshopProductsComparison']]);
	}
}
