<?php declare(strict_types = 1);

namespace EshopProductsComparison\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Manufacturer;
use EshopProductsComparison\Model\Helpers\ExportEnums;

#[ORM\Table(name: 'eshop_products_comparison__manufacturer_export')]
#[ORM\Entity]
class ManufacturerExport
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Manufacturer::class)]
	public Manufacturer $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $service;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 1])]
	public int $allowExport = 1;

	public function __construct(Manufacturer $id, string $lang, string $service)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->setService($service);
	}

	public function setService(string $service): self
	{
		if (ExportEnums::validateService($service)) {
			$this->service = $service;
		}

		return $this;
	}
}

