<?php declare(strict_types = 1);

namespace EshopProductsComparison\AdminModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use EshopCatalog\AdminModule\Components\Products\ProductsGrid;
use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\Model\Entities\Product;
use EshopProductsComparison\Model\Entities\ProductExport;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductsGridSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ProductsGrid::class . '::onAttach' => 'onAttach',
		];
	}

	public function onAttach(ControlEvent $event): void
	{
		/** @var ProductsGrid $control */
		$control = &$event->control;

		$control['grid']->addGroupTextAction('eshopProductsComparison.productsGrid.editZboziCustomlabel1')
			->onSelect[] = function(array $ids, $val) use ($control) {

			$exports = [];
			foreach ($this->em->getRepository(ProductExport::class)->createQueryBuilder('ppe')
				         ->where('ppe.id IN (' . implode(',', $ids) . ')')
				         ->andWhere('ppe.service = :service')
				         ->andWhere('ppe.lang = :lang')
				         ->setParameters([
					         'service' => 'zbozi',
					         'lang'    => 'cs',
				         ])->getQuery()->getResult() as $row) {
				/** @var ProductExport $row */
				$exports[$row->id->getId()] = $row;
			}

			foreach ($ids as $id) {
				/** @var Product $product */
				$product = $this->em->getReference(Product::class, $id);

				$export               = $exports[$id] ?? new ProductExport($product, 'cs', 'zbozi');
				$export->customLabel1 = $val;

				$this->em->persist($export);
			}

			$this->em->flush();

			$presenter = $control->presenter;
			$presenter->flashMessageSuccess('default.saved');
			$presenter->redrawControl('flashes');
		};
	}
}
