<?php declare(strict_types = 1);

namespace EshopProductsComparison\AdminModule\Presenters;

class DefaultPresenter extends BasePresenter
{

	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopProductsComparison.title.comparisons', 'fas fa-balance-scale');
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title'  => 'eshopProductsComparison.menu.updateExport',
				'link'   => $this->link(':EshopProductsComparison:Cron:Export:porovnavace',
					['type' => ['zbozi', 'google', 'heureka']]),
				'target' => '_blank',
				'ico'    => 'fas fa-sync',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
}
