<?php declare(strict_types = 1);

namespace EshopProductsComparison\CronModule\Presenters;

use Core\Model\Sites;
use Currency\Model\Currencies;
use EshopProductsComparison\FrontModule\Model\ExportFacade;
use Nette\Application\Responses\TextResponse;

class ExportPresenter extends BasePresenter
{
	protected ExportFacade $exportFacade;
	protected Sites $sites;
	protected Currencies $currencies;
	protected array $fileHandles = [];

	public function __construct(ExportFacade $exportFacade, Sites $sites, Currencies $currencies)
	{
		parent::__construct();
		$this->exportFacade = $exportFacade;
		$this->sites        = $sites;
		$this->currencies   = $currencies;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPorovnavace(): void
	{
		set_time_limit(1000);
		ini_set('memory_limit', '2048M');
		$params = $this->getParameters();
		$types  = $params['type'] ?? null;
		$site   = $params['site'] ? $this->sites->getSites()[$params['site']] : $this->sites->getCurrentSite();

		if (isset($params['currency'])) {
			Currencies::$currentCodeOverride = $params['currency'];
			$this->exportFacade->currency    = $params['currency'];
		}

		if ($params['lang'] && isset($site->getDomains()[$params['lang']])) {
			$domain = $site->getDomains()[$params['lang']];
		} else {
			$domain = $site->getCurrentDomain();
			$domain->setLang($params['lang']);
		}

		if ($types) {
			set_time_limit(1000);
			ini_set('memory_limit', '2048M');

			$this->exportFacade->generateExport($types, $site, $domain);
			$msg = 'ok';
		} else {
			$msg = 'error';
		}

		$response = new TextResponse($msg);
		$this->sendResponse($response);
	}
}
