<?php declare(strict_types = 1);

namespace EshopProductsComparison\DI;

use Core\DI\CompilerExtension;
use EshopProductsComparison\FrontModule\Model\Provider\IXmlExportService;
use Nette;

class EshopProductsComparisonExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopProductsComparison' => 'EshopProductsComparison\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var Nette\DI\Definitions\ServiceDefinition $def */
		$def = $builder->getDefinition('eshopProductsComparison.front.xmlExportCollection');
		$def->addSetup(new Nette\DI\Definitions\Statement('$service->setServices(?)', [$builder->findByType(IXmlExportService::class)]));
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopProductsComparison\Model\EshopProductsComparisonConfig::setParams(?);', [$builder->parameters['eshopProductsComparison']]);
	}
}
