<?php declare(strict_types = 1);

namespace EshopProductsComparison\FrontModule\Model\Event;

use EshopCatalog\FrontModule\Model\Dao\Product;
use Symfony\Contracts\EventDispatcher\Event;

class XmlShopItemEvent extends Event
{
	public \DOMDocument $dom;
	public \DOMElement $element;
	public Product     $product;
	public string      $service;

	public function __construct(
		\DOMDocument $dom,
		\DOMElement $element,
		Product     $product,
		string      $service
	)
	{
		$this->dom = $dom;
		$this->element = $element;
		$this->product = $product;
		$this->service = $service;
	}

}
