<?php declare(strict_types = 1);

namespace EshopProductsComparison\FrontModule\Model\Provider;

use EshopCatalog\FrontModule\Model\Dao\Product;

interface IXmlExportService
{
	public function getName(): string;

	/**
	 * @return void
	 */
	public function setBaseUrl(string $url);

	/**
	 * @return void
	 */
	public function setCurrency(string $currency);

	/**
	 * @return void
	 */
	public function startExport();

	/**
	 * @return void
	 */
	public function writeItem(Product $product);

	/**
	 * @return void
	 */
	public function endExport();
}
