<?php declare(strict_types = 1);

namespace EshopProductsComparison\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Manufacturer;
use EshopProductsComparison\Model\Helpers\ExportEnums;

/**
 * @ORM\Table(name="eshop_products_comparison__manufacturer_export")
 * @ORM\Entity
 */
class ManufacturerExport
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Manufacturer")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Manufacturer $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=false)
	 */
	public string $lang;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $service;

	/**
	 * @ORM\Column(type="smallint", options={"default": 1})
	 */
	public int $allowExport = 1;

	public function __construct(Manufacturer $id, string $lang, string $service)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->setService($service);
	}

	public function setService(string $service): self
	{
		if (ExportEnums::validateService($service)) {
			$this->service = $service;
		}

		return $this;
	}
}

