<?php declare(strict_types = 1);

namespace EshopProductsComparison\Model\Helpers;

class ExportEnums
{
	public const BASE_LANG = 'eshopProductsComparison.comparisons.';

	public const SERVICE_HEUREKA = 'heureka';
	public const SERVICE_ZBOZI   = 'zbozi';
	public const SERVICE_GOOGLE  = 'google';
	public const SERVICE_FACEBOOK  = 'facebook';
	public const SERVICE_IDEALO  = 'idealo';

	public const STATUS_DISABLED = 0;
	public const STATUS_ACTIVE   = 1;
	public const STATUS_INHERIT  = 2;

	public static array $services = [
		self::SERVICE_HEUREKA => [
			'title'  => self::BASE_LANG . self::SERVICE_HEUREKA . '.title',
			'fields' => [
				'productName', 'product', 'categoryText', 'bidCpc',
				'textarea' => ['productDescription'],
			],
			'showLang' => ['cs', 'sk'],
		],
		self::SERVICE_ZBOZI   => [
			'title'  => self::BASE_LANG . self::SERVICE_ZBOZI . '.title',
			'fields' => [
				'productName', 'product', 'categoryText', 'bidCpc',
				'textarea' => ['productDescription'],
				'customLabel1',
			],
			'showLang' => ['cs', 'sk'],
		],
		self::SERVICE_GOOGLE  => [
			'title'  => self::BASE_LANG . self::SERVICE_GOOGLE . '.title',
			'fields' => [
				'product', 'categoryText',
				'textarea' => ['productDescription'],
				'customLabel0',
				'customLabel1',
				'customLabel2',
				'customLabel3',
				'customLabel4',
			],
			'showLang' => [],
		],
		self::SERVICE_FACEBOOK  => [
			'title'  => self::BASE_LANG . self::SERVICE_FACEBOOK . '.title',
			'fields' => [
				'product', 'categoryText',
				'textarea' => ['productDescription'],
				'customLabel0',
				'customLabel1',
				'customLabel2',
				'customLabel3',
				'customLabel4',
			],
			'showLang' => [],
		],
		self::SERVICE_IDEALO => [
			'title'  => self::BASE_LANG . self::SERVICE_IDEALO . '.title',
			'fields' => [
				'product', 'categoryText',
			],
			'showLang' => ['de'],
		],
	];

	public static array $statuses = [
		self::STATUS_DISABLED => [
			'title'    => self::BASE_LANG . 'statuses.disabled',
			'btnClass' => 'danger',
		],
		self::STATUS_ACTIVE   => [
			'title'    => self::BASE_LANG . 'statuses.active',
			'btnClass' => 'success',
		],
		self::STATUS_INHERIT  => [
			'title'    => self::BASE_LANG . 'statuses.inherit',
			'btnClass' => 'secondary',
		],
	];

	public static function statusesForSelect(): array
	{
		$arr = self::$statuses;

		array_walk($arr, static function(&$a, $b) { $a = $a['title']; });

		return $arr;
	}

	public static function validateService(string $service): bool
	{
		return array_key_exists($service, self::$services);
	}
}
