<?php declare(strict_types = 1);

namespace EshopProductsComparison\FrontModule\Model\Export;

use Core\Model\Helpers\BaseService;
use EshopProductsComparison\FrontModule\Model\Provider\IXmlExportService;

class XmlExportCollection extends BaseService
{
	/** @var IXmlExportService[] */
	protected array $services = [];

	/** @return IXmlExportService[] */
	public function getServices(): array { return $this->services; }

	/**
	 * @param IXmlExportService[] $services
	 */
	public function setServices(array $services): void
	{
		foreach ($services as $service) {
			$this->services[$service->getName()] = $service;
		}
	}
}
