<?php declare(strict_types = 1);

namespace EshopProductsComparison\FrontModule\Model\Subscribers;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\DaoEvent;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\Dao\Category;
use EshopProductsComparison\Model\Entities\CategoryExport;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class EshopCatalogSubscriber implements EventSubscriberInterface
{
	protected ?array $cCategoryExport = null;

	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			Categories::class . '::fillDao' => 'categoryFillDao',
		];
	}

	public function categoryFillDao(DaoEvent $event): void
	{
		/** @var Category $category */
		$category        = &$event->dao;
		$categoryExports = $this->getCategoryExport();
		$catExports      = $categoryExports[$category->getId()] ?? [];
		$needLoop        = [];
		$cat             = $category;
		while (count($needLoop) !== 3 && $cat) {
			if (isset($categoryExports[$cat->id])) {
				foreach ($categoryExports[$cat->id] as $service => $data) {
					if (!isset($needLoop[$service])) {
						$catExports[$service] = $data;
					}

					if ($data['status'] !== 2) {
						$needLoop[$service] = false;
					}
				}
			}
			$cat = $cat->getParent();
		}

		if ($catExports) {
			$category->attrs['productsComparison']['exports'] = $catExports;
		}
	}

	protected function getCategoryExport(): array
	{
		if ($this->cCategoryExport === null) {
			$this->cCategoryExport = [];
			foreach ($this->em->getRepository(CategoryExport::class)->createQueryBuilder('ce')
				         ->where('ce.lang = :lang')->setParameter('lang', $this->translator->getLocale())
				         ->getQuery()->getArrayResult() as $row) {
				/** @var array $row */
				$this->cCategoryExport[$row['id']][$row['service']] = $row;
			}
		}

		return $this->cCategoryExport;
	}
}
