<?php declare(strict_types = 1);

namespace EshopProductsComparison\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Category;
use EshopProductsComparison\Model\Helpers\ExportEnums;

#[ORM\Table(name: 'eshop_products_comparison__category_export')]
#[ORM\Entity]
class CategoryExport
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Category::class)]
	public Category $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $service;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 2])]
	public int $status = 2;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $categoryText = null;

	#[ORM\Column(name: 'custom_label0', type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel0 = null;

	#[ORM\Column(name: 'custom_label1', type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel1 = null;

	#[ORM\Column(name: 'custom_label2', type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel2 = null;

	#[ORM\Column(name: 'custom_label3', type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel3 = null;

	#[ORM\Column(name: 'custom_label4', type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel4 = null;

	public function __construct(Category $id, string $lang, string $service)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->setService($service);
	}

	public function setService(string $service): self
	{
		if (ExportEnums::validateService($service)) {
			$this->service = $service;
		}

		return $this;
	}
}

