<?php declare(strict_types = 1);

namespace EshopProductsComparison\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use EshopProductsComparison\Model\Helpers\ExportEnums;

#[ORM\Table(name: 'eshop_products_comparison__product_export')]
#[ORM\Entity]
class ProductExport
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', nullable: false)]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	public Product $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $service;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 2])]
	public int $status;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $product = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $productName = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $productDescription = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $categoryText = null;

	/**
	 * @var float|null
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
	public $bidCpc;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel0 = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel1 = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel2 = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel3 = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $customLabel4 = null;

	public function __construct(Product $id, string $lang, string $service)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->setService($service);
		$this->status = ExportEnums::STATUS_INHERIT;
	}

	public function setService(string $service): self
	{
		if (ExportEnums::validateService($service)) {
			$this->service = $service;
		}

		return $this;
	}

}
