<?php declare(strict_types = 1);

namespace EshopSales\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use EshopSales\AdminModule\Components\Order\IOrderSaleFormFactory;
use EshopSales\AdminModule\Components\Order\IOrderSalesGridFactory;
use EshopSales\AdminModule\Components\Order\OrderSaleForm;
use EshopSales\AdminModule\Components\Order\OrderSalesGrid;
use EshopSales\Model\Entities\OrderSale;

class DefaultPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-money-check-alt';

	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopSales.title.sales', self::ICON);
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleAddOrderSale(): void
	{
		$this->template->modalTitle = $this->t('eshopSales.title.addOrderSale');
		$this->template->modal      = 'orderSaleForm';
		$this->redrawControl('modal');
	}

	public function handleEditOrderSale(int $id): void
	{
		/** @var OrderSale $orderSale */
		$orderSale = $this->em->getRepository(OrderSale::class)->find($id);

		if (!$orderSale)
			$this->error();

		$this['orderSaleForm']->id = $id;
		$this['orderSaleForm']->setOrderSale($id);
		$this->template->modalTitle = $this->t('eshopSales.title.editOrderSale');
		$this->template->modal      = 'orderSaleForm';
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopSales.menu.addOrderSale',
				'link'  => $this->link('addOrderSale!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderSaleForm(IOrderSaleFormFactory $factory): OrderSaleForm
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$control['form']->onSuccessSave[]         = function(BaseForm $form) use ($control) {
				$this->handleEditOrderSale((int) $form->getCustomData('orderSaleId'));
				$this->redrawControl('flashes');
				$this['orderSalesGrid']['grid']->reload();
			};
			$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) use ($control) {
				$this->payload->hideModal = true;
				$this->redrawControl('flashes');
				$this['orderSalesGrid']['grid']->reload();
			};
			$control['form']['saveControl']->closeModalOnCancel();
		};

		return $control;
	}

	protected function createComponentOrderSalesGrid(IOrderSalesGridFactory $factory): OrderSalesGrid
	{
		return $factory->create();
	}
}
