<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\Discount;
use EshopOrders\FrontModule\Model\Event\AddedCartItemEvent;
use EshopOrders\FrontModule\Model\Event\FillDaoEvent;
use EshopOrders\FrontModule\Model\Event\FillDaoItemsEvent;
use EshopOrders\FrontModule\Model\Event\RemovedCartItemEvent;
use EshopOrders\FrontModule\Model\Event\UpdatedCartItemEvent;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\Model\Entities\OrderSale;

class CartSubscriber implements EventSubscriber
{
	/** @var Carts */
	protected $cartsService;

	/** @var OrderSales */
	protected $orderSales;

	public function __construct(Carts $carts, OrderSales $orderSales)
	{
		$this->cartsService = $carts;
		$this->orderSales   = $orderSales;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.cartFillDao' => ['cartFillDao', 99],
		];
	}

	public function cartFillDao(FillDaoEvent $event): void
	{
		$cart = $event->cart;
		$key  = 'ESHOPSALESAUTO';

		$cart->removeDiscount($key);
		$cartItemsPrice = $cart->getCartItemsPrice();
		$sales          = $this->orderSales->getAutoSales();

		foreach ($sales as $k => $sale) {
			if ($cartItemsPrice < $sale['fromPrice'])
				break;

			if ($cartItemsPrice >= $sale['fromPrice'] && (!isset($sales[$k + 1]) || $cartItemsPrice < $sales[$k + 1]['fromPrice'])) {
				$discount             = new Discount($key, (float) $sale['amount'], $sale['type']);
				$discount->typeSymbol = OrderSale::TYPES[$sale['type']]['symbol'];
				$cart->addDiscount($key, $discount);
			}
		}
	}
}
