<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\Event\ComponentTemplateEvent;
use Core\Model\Event\PresenterTemplateEvent;
use EshopOrders\FrontModule\Model\Carts;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\Model\Config;

class FrontSubscriber implements EventSubscriber
{
	/** @var Config */
	protected $config;

	/** @var OrderSales */
	protected $orderSales;

	/** @var Carts */
	protected $cartService;

	public function __construct(Config $config, OrderSales $orderSales, Carts $carts)
	{
		$this->config      = $config;
		$this->orderSales  = $orderSales;
		$this->cartService = $carts;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'core.front.beforeRender'                   => ['beforeRender', 100],
			'eshopOrders.orderCartDetail.renderSummary' => ['orderCartDetailRenderSummary', 100],
			'eshopOrders.orderCartDetail.render'        => ['orderCartDetailRender', 100],
			'eshopOrders.cartDetail.render'             => ['cartDetailRender', 100],
			'eshopOrders.orderSummary.render'           => ['orderSummaryRender', 100],
		];
	}

	public function beforeRender(PresenterTemplateEvent $event): void
	{
	}

	public function orderCartDetailRenderSummary(ComponentTemplateEvent $event): void
	{
		$this->setTemplateNextOrderSales($event);
	}

	public function orderCartDetailRender(ComponentTemplateEvent $event): void
	{
		$this->setTemplateNextOrderSales($event);
	}

	public function cartDetailRender(ComponentTemplateEvent $event): void
	{
		$this->setTemplateNextOrderSales($event);
	}

	public function orderSummaryRender(ComponentTemplateEvent $event): void
	{
		$this->setTemplateNextOrderSales($event);
	}

	protected function setTemplateNextOrderSales(ComponentTemplateEvent $event): void
	{
		if ($this->config->get('cartComponentsLoadNextOrderSales') !== true)
			return;

		$event->template->nextOrderSales = $this->orderSales->getNextSales($this->cartService->getCurrentCart()->getCartItemsPrice());
	}
}
