<?php declare(strict_types = 1);

namespace EshopSales\AdminModule\Components\Order;

use stdClass;
use Core\Model\Http\CsvResponse;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopSales\AdminModule\Model\Mappers\OrderSale\ICsvMapper;
use EshopSales\AdminModule\Model\OrderSales;
use Exception;
use Nette\Utils\ArrayHash;
use Tracy\Debugger;

class ExportOrderSaleForm extends BaseControl
{
	protected const OPTION_ONLY_WITH_FILLED_DESC = 'onlyWithFilledDesc';

	public function __construct(
		protected OrderSales $orderSales,
		protected ICsvMapper $csvMapper,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax()
			->setShowLangSwitcher(false);

		$items = [
			self::OPTION_ONLY_WITH_FILLED_DESC => $this->t('eshopSales.exportOrderSaleForm.options.items.onlyWithFilledDesc'),
		];
		$form->addCheckboxList('options', 'eshopSales.exportOrderSaleForm.options.caption', $items);

		$form->addSaveCancelControl();

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$this->redirect('downloadSalesCsv', base64_encode(serialize($values)));
	}

	public function handleDownloadSalesCsv(string $payload): void
	{
		/** @var stdClass $values */
        $values = unserialize(base64_decode($payload));

		try {
			$qb = $this->orderSales->getEr()->createQueryBuilder('os');

			if (in_array(self::OPTION_ONLY_WITH_FILLED_DESC, $values->options, true)) {
				$qb->andWhere('os.description IS NOT NULL AND LENGTH(os.description) > 0');
			}

			CsvResponse::sendResponse("sales.csv", $this->csvMapper->toRaw($qb->getQuery()->getResult()));
		} catch (Exception $e) {
			Debugger::log($e);
		}
	}

}
