<?php declare(strict_types = 1);

namespace EshopSales\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use Nette\Utils\ArrayHash;

class OrderSalesStatistics extends BaseControl
{
	public function __construct(
		protected Orders $orders,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax()->setShowLangSwitcher(false);

		$form->addText('code', 'eshopSales.orderSalesStatistics.code')
			->setRequired();

		$form->addSubmit('send', 'default.search');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$qb = $this->orders->getFullOrderQb();
		$qb->andWhere('discounts.code = :code')
			->setParameter('code', $values['code']);

		$this->template->sumOrders   = 0;
		$this->template->countOrders = 0;

		/** @var Order $order */
		foreach ($qb->getQuery()->getResult() as $order) {
			$this->template->countOrders += 1;
			$this->template->sumOrders   += $order->getPrice();
		}

		$this->redrawControl('result');
	}

}
