<?php declare(strict_types = 1);

namespace EshopSales\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopSales\AdminModule\Model\OrderSales;
use EshopSales\Model\EshopSalesConfig;
use Nette\Utils\Html;

class PurchasedDiscountsGrid extends BaseControl
{
	public function __construct(
		protected OrderSales $orderSales,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * =================  Components
	 */

	public function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		if (EshopSalesConfig::load('purchasedDiscountsGrid.csvExport')) {
			$grid->addExportCsv('CSV Export', 'slevy.csv', 'windows-1250', ';', false, true);
		}

		$grid->setDataSource($this->orderSales->getPurchasedDiscounts());

		$grid->addColumnText('productName', 'eshopSales.purchasedDiscountsGrid.product')
			->setFilterText();
		$grid->addColumnText('order', 'eshopSales.purchasedDiscountsGrid.order')
			->setAlign('center')
			->setTemplateEscaping(false)
			->setRenderer(function(array $purchasedDiscount) {
				$html = Html::el();
				$html->addHtml(
					Html::el('a', [
						'href'   => $this->presenter->link(':EshopOrders:Admin:Default:editOrder', $purchasedDiscount['order']),
						'target' => '_blank',
					])->setText($purchasedDiscount['order'])
				);

				return $html;
			})->setFilterText();
		$grid->addColumnText('code', 'eshopSales.purchasedDiscountsGrid.code')
			->setFilterText();
		$grid->addColumnText('invoice', 'eshopSales.purchasedDiscountsGrid.invoice')
			->setFitContent()
			->setFilterText();
		$grid->addColumnDateTime('purchased', 'eshopSales.purchasedDiscountsGrid.purchased')
			->setFitContent()
			->setAlign('right')
			->setFormat('d.m.Y')
			->setFilterDateRange();
		$grid->addColumnText('appliedInOrder', 'eshopSales.purchasedDiscountsGrid.appliedInOrder')
			->setTemplateEscaping(false)
			->setRenderer(function(array $purchasedDiscount) {
				$html = Html::el();
				$html->addHtml(
					Html::el('a', [
						'href'   => $this->presenter->link(':EshopOrders:Admin:Default:editOrder', $purchasedDiscount['appliedInOrder']),
						'target' => '_blank',
					])->setText($purchasedDiscount['appliedInOrder'])
				);

				return $html;
			})->setFilterText();
		$grid->addColumnText('appliedInOrderInvoice', 'eshopSales.purchasedDiscountsGrid.appliedInOrderInvoice')
			->setFilterText();
		$grid->addColumnText('dateFrom', 'eshopSales.purchasedDiscountsGrid.dateFrom')
			->setFitContent()
			->setAlign('right')
			->setFilterDateRange();
		$grid->addColumnText('dateTo', 'eshopSales.purchasedDiscountsGrid.dateTo')
			->setFitContent()
			->setAlign('right')
			->setFilterDateRange();
		$grid->addColumnText('status', 'eshopSales.purchasedDiscountsGrid.status')
			->setRenderer(fn($v) => $this->t('eshopSales.purchasedDiscountsGrid.' . $v['status']))
			->setFilterSelect([
				null            => null,
				'applied'       => $this->t('eshopSales.purchasedDiscountsGrid.applied'),
				'notApplied'    => $this->t('eshopSales.purchasedDiscountsGrid.notApplied'),
				'codeNotExists' => $this->t('eshopSales.purchasedDiscountsGrid.codeNotExists'),
			], 'status');

		return $grid;
	}

}
