<?php declare(strict_types = 1);

namespace EshopSales\CronModule\Presenters;

use EshopSales\AdminModule\Model\OrderSales;
use Tracy\Debugger;

class ImportPresenter extends BasePresenter
{
	public function __construct(
		protected OrderSales $orderSales,
	)
	{
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	public function actionBulkImportHolidays(): void
	{
		set_time_limit(1000);
		ini_set('memory_limit', '2048M');
		Debugger::$showBar = false;

		$this->orderSales->bulkImportHolidays();

		$this->terminate();
	}
}
