<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopSales\AdminModule\Model\OrderSales as AdminOrderSales;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\Model\Entities\OrderSale;
use Exception;
use Nette\Application\UI\Multiplier;

class DiscountsGrid extends BaseControl
{
	public function __construct(
		protected OrderSales                 $orderSales,
		protected IDiscountDetailItemFactory $discountDetailItemFactory,
		protected Carts                      $carts,
		protected AdminOrderSales            $adminOrderSales,
	)
	{
	}

	public function createComponentDiscountDetailItem(): Multiplier
	{
		$factory = $this->discountDetailItemFactory;

		return new Multiplier(function($id) use ($factory) {
			/** @var OrderSale $orderSale */
			$orderSale = $this->adminOrderSales->get($id);

			return $factory->create($orderSale);
		});
	}

	/**
	 * @throws Exception
	 */
	public function render(): void
	{
		$this->template->items = $this->orderSales->getOrderSalesFromCart($this->carts->getCurrentCart()->getCartItemsPrice());
		$this->template->render($this->getTemplateFile());
	}

}
