<?php declare(strict_types = 1);

namespace EshopSales\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_sales__order_sale_in_site')]
#[ORM\Entity]
class OrderSaleInSite
{
	#[ORM\JoinColumn(name: 'order_sale_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: OrderSale::class)]
	public OrderSale $orderSale;

	#[ORM\JoinColumn(name: 'site_id', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Site::class)]
	public Site $site;

	public function __construct(OrderSale $orderSale, Site $site)
	{
		$this->orderSale = $orderSale;
		$this->site      = $site;
	}

}
