<?php declare(strict_types = 1);

namespace EshopSales\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_sales__used_order_sale_in_site')]
#[ORM\Entity]
class UsedOrderSaleInSite
{
	#[ORM\JoinColumn(name: 'used_order_sale_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: UsedOrderSale::class)]
	public UsedOrderSale $usedOrderSale;

	#[ORM\JoinColumn(name: 'site_id', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Site::class)]
	public Site $site;

	public function __construct(UsedOrderSale $usedOrderSale, Site $site)
	{
		$this->usedOrderSale = $usedOrderSale;
		$this->site          = $site;
	}

}
