<?php declare(strict_types = 1);

namespace EshopSales\Model\Listeners;

use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopSales\Model\Entities\OrderSale;
use Nette\Utils\Validators;

class OrderSaleListener
{
	#[ORM\PreUpdate]
	public function preUpdate(OrderSale $orderSale, PreUpdateEventArgs $event): void
	{
		$maxRepetitionsField = 'maxRepetitions';

		if ($event->hasChangedField($maxRepetitionsField)) {
			$maxRepetitionsFieldOldValue = $event->getOldValue($maxRepetitionsField) ? (int) $event->getOldValue($maxRepetitionsField) : null;
			$maxRepetitionsFieldNewValue = $event->getNewValue($maxRepetitionsField) ? (int) $event->getNewValue($maxRepetitionsField) : null;

			if ($maxRepetitionsFieldOldValue === null
				|| $orderSale->currentRepetitions === null
				|| $maxRepetitionsFieldNewValue < $orderSale->currentRepetitions
				|| $maxRepetitionsFieldNewValue === null) {
				$orderSale->currentRepetitions = $event->getNewValue($maxRepetitionsField);
			} else if ($maxRepetitionsFieldNewValue > $maxRepetitionsFieldOldValue) {
				// increases the original value by the difference between the original value and the new value
				$orderSale->currentRepetitions += $maxRepetitionsFieldNewValue - $maxRepetitionsFieldOldValue;
			}
		}
	}
}
