document.addEventListener('DOMContentLoaded', () => {
});
global.naja.addEventListener('complete', e => {
	initCalculateCurrencies();
});

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initCalculateCurrencies();
});

const initCalculateCurrencies = () => {
	const formEl = document.querySelector('[id*="orderSaleForm"]');
	console.log(formEl);
	if (!formEl) {
		return;
	}

	const wrap    = formEl.querySelector('.price-in-other-currencies');
	const valueEl = formEl.querySelector('[name="amount"]');
	const typeEl  = formEl.querySelector('[name="type"]');
	const siteEl  = formEl.querySelector('[name="site"]');

	if (!wrap || !valueEl || !typeEl || !siteEl) {
		return;
	}

	const data = JSON.parse(wrap.dataset.data);

	function change() {
		if (typeEl.value !== 'fix') {
			wrap.innerHTML = '-';
			return;
		}

		let tableRows = '';

		function addRow(site, currency, price) {
			tableRows += '<tr><td>' + site + '</td><td>' + currency + '</td><td style="text-align: right">' + Math.round(price) + '</td></tr>';
		}

		if (siteEl.value && data[siteEl.value] !== undefined) {
			for (let curr in data[siteEl.value]) {
				let item = data[siteEl.value][curr];

				addRow(siteEl.value, curr, valueEl.value / item.rate);
			}
		} else {
			for (let site in data) {
				let currencies = data[site];

				for (let curr in currencies) {
					let item = currencies[curr];

					addRow(site, curr, valueEl.value / item.rate);
				}
			}
		}

		wrap.innerHTML = '<table style="width: 100%">' + tableRows + '</table>';
	}

	change();
	valueEl.addEventListener('keyup', change);
	typeEl.addEventListener('change', change);
	siteEl.addEventListener('change', change);
}

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name !== 'saleProduct') {
		return;
	}

	const resp      = e;
	const input     = resp.target;
	const selection = resp.detail.selection;

	input.value = '';

	const table = document.querySelector('[data-target="' + input.id + '"]');

	if (!table) {
		return;
	}

	addRow(
		table,
		input.dataset.productLink,
		selection.value.id,
		selection.value.code1,
		selection.value.name,
	);
});

const addRow = (table, productLink, id, code1, name) => {
	const tr = document.createElement('tr');
	tr.setAttribute('data-id', id);

	const tdCode     = document.createElement('td');
	tdCode.innerText = code1;

	const tdName     = document.createElement('td');
	tdName.innerHTML = '<a href="'+productLink.replace('__ID__', id)+'" target="_blank">'+name+'</a><input name="product[' + id + ']" type="hidden"  value="' + id + '">';

	const tdAction     = document.createElement('td');
	tdAction.innerHTML = '<a href="javascript:;" class="btn btn-xs btn-danger" data-remove-table-tr><i class="fas fa-times"></i></a>';

	tr.appendChild(tdCode);
	tr.appendChild(tdName);
	tr.appendChild(tdAction);

	table.querySelector('tbody').appendChild(tr);
}
