<?php declare(strict_types=1);

namespace EshopSales\AdminModule\Model\Mappers\OrderSale;

use EshopSales\Model\Entities\OrderSale;

interface ICsvMapper
{
	/**
	 * Normalize data from csv file to normalized structurcture for proccess by EshopSales\AdminModule\Model\OrderSales::save
	 * @return array
	 */
	public function normalize(array $fileContent): array;

	/**
	 * @param OrderSale[] $orderSales
	 */
	public function toRaw(array $orderSales): string;
}