<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\Event\Event;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Controls\SubmitButtonInput;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\Model\Entities\OrderSale;
use Nette\Utils\ArrayHash;

class DiscountDetailItem extends BaseControl
{
	protected OrderSale $orderSale;

	protected OrderSales $orderSales;

	protected CartFacade $cartFacade;

	public function __construct(OrderSale $orderSale, OrderSales $orderSales, CartFacade $cartFacade)
	{
		$this->orderSale  = $orderSale;
		$this->orderSales = $orderSales;
		$this->cartFacade = $cartFacade;
	}

	public function render(): void
	{
		$cart                     = $this->cartFacade->getCart();
		$this->template->item     = $this->orderSale;
		$this->template->discount = $cart->discounts[$this->orderSale->code] ?? null;
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentItemForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->addHidden('orderSaleId')
			->setDefaultValue($this->orderSale->getId())
			->setRequired();

		if (!$this->orderSale->isAutoSale()) {
			$form->addSubmit('submitRemove');
		}

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm  $form
	 * @param ArrayHash $values
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		/** @var SubmitButtonInput $control */
		$control = $form['submitRemove'];
		if ($control->isSubmittedBy()) {
			$this->orderSales->removeFromCart((int) $values->orderSaleId);
		}

		$this->eventDispatcher->dispatch(new Event(), 'eshopSales.discountCodesChanged');
	}
}
