<?php declare(strict_types=1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\AdminModule\Model\OrderSales as AdminOrderSales;
use Exception;
use Nette\Application\UI\Multiplier;

class DiscountsGrid extends BaseControl
{
	/** @var OrderSales */
	protected $orderSales;

	/** @var AdminOrderSales */
	protected $adminOrderSales;

	/** @var IDiscountDetailItemFactory */
	protected $discountDetailItemFactory;

	/** @var Carts */
	protected $carts;

	/**
	 * DiscountsGrid constructor.
	 * @param OrderSales $orderSales
	 * @param IDiscountDetailItemFactory $discountDetailItemFactory
	 * @param Carts $carts
	 * @param AdminOrderSales $adminOrderSales
	 */
	public function __construct(OrderSales $orderSales, IDiscountDetailItemFactory $discountDetailItemFactory, Carts $carts, AdminOrderSales $adminOrderSales)
	{
		$this->orderSales = $orderSales;
		$this->discountDetailItemFactory = $discountDetailItemFactory;
		$this->carts = $carts;
		$this->adminOrderSales = $adminOrderSales;
	}

	/**
	 * @return Multiplier
	 */
	public function createComponentDiscountDetailItem(): Multiplier
	{
		$factory = $this->discountDetailItemFactory;
		return new Multiplier(function ($id) use ($factory) {
			$orderSale = $this->adminOrderSales->get($id);
			return $factory->create($orderSale);
		});
	}

	/**
	 * @throws Exception
	 */
	public function render(): void
	{
		$this->template->items = $this->orderSales->getOrderSalesFromCart($this->carts->getCurrentCart()->getCartItemsPrice());
		$this->template->render($this->getTemplateFile());
	}

}
