<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopSales\FrontModule\Model\Event\OrderSalesPriceEvent;
use EshopSales\FrontModule\Model\OrderSales;

class OrderSalesSubscriber implements EventSubscriberInterface
{
	public static function getSubscribedEvents(): array
	{
		return [
			OrderSales::class . '::validatePriceFrom' => ['validatePriceFrom', 100],
		];
	}

	public function validatePriceFrom(OrderSalesPriceEvent $event): void
	{
		foreach ($event->orderSales as $k => $orderSale) {
			if ($event->cartPrice < $orderSale->fromPrice)
				unset($event->orderSales[$k]);
		}
	}
}
