<?php declare(strict_types = 1);

namespace EshopSales\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopSales\FrontModule\Model\Dao\OrderSale;
use EshopSales\FrontModule\Model\OrderSales;
use Exception;

/**
 * @Path("/sales")
 */
class OrderSalesController extends BaseController
{
	public function __construct(
		protected OrderSales $orderSales,
	)
	{
	}

	/**
	 * @Path("/check-discount-code-validity")
	 * @Method("POST")
	 */
	public function checkDiscountCodeValidity(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$data = $request->getJsonBody();

		try {
			$code           = $data['code'];
			$cartItemsPrice = (float) $data['totalPrice'];

			$validDiscountCode = $this->orderSales->isValidDiscountCode($code, $cartItemsPrice, true);

			return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
				'status' => $validDiscountCode instanceof OrderSale ? 'success' : 'error',
				'data'   => $validDiscountCode,
			]));
		} catch (Exception $e) {

			return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
				'error' => $e->getMessage(),
				'data'  => $data,
			]));
		}
	}
}
