<?php declare(strict_types = 1);

namespace EshopSales\Console;

use Doctrine;
use EshopSales\AdminModule\Model\HolidaysExport;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshopsales:holidayExport:ecomail')]
class EcomailExport extends Command
{

	public function __construct(
		public HolidaysExport $holidaysExport,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshopsales:holidayExport:ecomail')
			->addOption('site', null, InputOption::VALUE_REQUIRED)
			->addOption('lang', null, InputOption::VALUE_REQUIRED);
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('EshopSales - holidays export to ecomail');

		try {
			/** @var string $site */
			$site = $input->getOption('site');
			/** @var string $lang */
			$lang = $input->getOption('lang');
			$this->holidaysExport->exportToEcoMail($site, $lang);

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
