<?php declare(strict_types = 1);

namespace EshopSales\Model\Entities;

use Core\Model\Entities\TId;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;

#[ORM\Table('eshop_sales__used_order_sale')]
#[ORM\Entity]
class UsedOrderSale implements IDiscount
{
	use TId;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $code;

	#[ORM\Column(name: 'type', type: Types::STRING, nullable: false, options: ['default' => 'price'])]
	public string $type;

	/**
	 * @var float
	 */
	#[ORM\Column(name: 'amount', type: Types::DECIMAL, precision: 10, scale: 3, nullable: false)]
	public $amount;

	/**
	 * @var float
	 */
	#[ORM\Column(name: 'from_price', type: Types::DECIMAL, precision: 10, scale: 3, nullable: false)]
	public $fromPrice;

	#[ORM\Column(name: 'date_from', type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $dateFrom = null;

	#[ORM\Column(name: 'date_to', type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $dateTo = null;

	/**
	 * Jakou polozkou objednavky byl slevovy poukaz vytvoren
	 */
	#[ORM\JoinColumn(name: 'created_by_order_item', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: OrderItem::class)]
	public ?OrderItem $createdByOrderItem = null;

	/**
	 * V jake objednavce byl aplikovan
	 */
	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	public ?Order $order;

	#[ORM\Column(name: 'description', type: Types::TEXT, nullable: true)]
	public ?string $description;

	/** @var Collection<UsedOrderSaleInSite> */
	#[ORM\OneToMany(mappedBy: 'usedOrderSale', targetEntity: UsedOrderSaleInSite::class, cascade: ['all'], orphanRemoval: true, indexBy: 'site')]
	public Collection $sites;

	public function __construct(
		string    $type, ?string $code, float $amount, float $fromPrice, ?Order $order,
		?DateTime $dateFrom, ?DateTime $dateTo, ?string $description
	)
	{
		$this->code        = $code;
		$this->type        = $type;
		$this->amount      = $amount;
		$this->dateFrom    = $dateFrom;
		$this->dateTo      = $dateTo;
		$this->fromPrice   = $fromPrice;
		$this->description = $description;
		$this->order       = $order;
		$this->sites       = new ArrayCollection;
	}

	public function getValue(): float
	{
		return (float) $this->amount;
	}

	public function getType(): string
	{
		return $this->type;
	}
}
